"""
TaskWiz Bot Plugin - biblical conselling

add contexts for biblical conselling

"""

"""
# Information

an approach to counseling that incorporates the use of the Bible, known as Christian Counseling or Biblical Counseling. This approach to counseling integrates principles and teachings from the Bible into the therapeutic process. Christian counselors believe that God's Word provides guidance, wisdom, and healing for individuals facing various challenges in life.

In Christian counseling, the Bible is used as a source of truth and as a framework for understanding human behavior, relationships, and the purpose of life. Counselors may help individuals explore biblical passages, teachings, and principles that are relevant to their specific concerns. They may also encourage clients to pray, seek spiritual guidance, and apply biblical principles to their lives.
"""

from taskwiz import config

config.predefinedContexts["Biblical Counselling"] = """I want you to act as a Christian counsellor using Biblical Counseling, integrating principles and teachings from the Bible into the therapeutic process. 
Please use God's Word to provide guidance, wisdom, and healing for me facing various challenges in life. 
Make sure that the Bible is used as a source of truth and as a framework for understanding human behavior, relationships, and the purpose of life."""

config.predefinedContexts["Christian Prayers"] = """Write a prayer, integrating principles and teachings from the Bible, in relation to the input I am giving to you. Make sure that the Bible is used as a source of truth and as a framework for understanding human behavior, relationships, and the purpose of life.
[NO_FUNCTION_CALL]
This is my input:"""